function u_node_val=set_boeing_velocity

global_vars;

M=size(u_node_pos)*[1;0];
u_node_val=zeros(M,2);

for k=1:n_u_node
    if u_node_type(k)==0 % interior point
        u_node_val(u_node_pos_to_val(k),:)=[0,0];
    elseif u_node_type(k)==1 % Air foil - No-slip boundary
        u_node_val(u_node_pos_to_val(k),:)=[0,0];
    elseif u_node_type(k)==2 % Proscribed boundary
%         u_node_val(u_node_pos_to_val(k),:)=[2,0]*(2-u_node_pos(k,1))/3+[1,0]*(1+u_node_pos(k,1))/3;
        u_node_val(u_node_pos_to_val(k),:)=[0,0];
    elseif u_node_type(k)==3 % In-flow
        u_node_val(u_node_pos_to_val(k),:)=[1,0];
    elseif u_node_type(k)==4 % Out-flow
        u_node_val(u_node_pos_to_val(k),:)=[1,0];
    end
end
